﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Collections;
using UnityEngine;
using UnityEngine.UI;

public class btle_controller : MonoBehaviour {

    #region BLESettings
    private string _FullUID = "0000****-0000-1000-8000-00805f9b34fb";     // BLE-CC41a module pattern 
    private string _serviceUUID = "ffe0";
    private string _readCharacteristicUUID = "ffe1";
    private string _writeCharacteristicUUID = "ffe1";
    private string deviceToConnectTo = "Powerbox";

    public bool isConnected = false;
    private bool _readFound = false;
    private bool _writeFound = false;
    private string _connectedID = null;

    private Dictionary<string, string> _peripheralList;
    private float _subscribingTimeout = 0f;
    #endregion

    #region Declare Panels
    public bool isMainActive = true; 
    public bool isBatteryVoltActive = true; 
    public bool isBatteryTempActive = true; 
		public bool isBatteryDataActive = true;
    public Text txtDebug;
    public GameObject uiPanel;
    public GameObject connectPanel;
    #endregion

    #region Declare Buttons
    public Button tuningLightBtn;
    public Button tuningMediumBtn;
    public Button tuningMaxBtn;
    public Button tuningOriginalBtn;
    public Button tuningT80T45Btn;
    public Button tuningExitBtn;
    
    public Text tuningValue;
    public Text FWVersionValue;

    public Button profileEcoBtn;
    public Button profileNormalBtn;
    public Button profileSportBtn;
    public Button profileRegenBtn;
    public Button ProfileAutManBtn;
    public Button PBFWBtn;
    public Button SetupBackBtn;
	  
    public Text BatteryText17Verify;

    public Button regenBtn;
    public Button footBrakeBtn;
    
    public Button tuningBtn;
    public Button batteryBtn;

    public Button batteryExitBtn;
    #endregion

    #region Declare Settings

    //private Button DataLastPressed = null;
    public Text mainInfoVerify;
    public Text bTempVerify;
    public Text mTempVerify;
    public Text kWhVerify;
    public Text NmVerify;
    public Text AmpVerify;
    public Text RPMVerify;
    public Text SOHVerify;
		public Text SOCVerify;
		public Text TuningVerify;
		public Text FirmwareVerify;

    private Text txtReceive;
    private string strReceive;
    public bool batCellVoltUpdBool = false;

    private string bTempstr;
    private string mTempstr;
    private string kWhstr;
    private string Nmstr;
    private string Ampstr;
    private string RPMstr;
    private string SOHstr;
    private string SOCstr;
    private string Tuningstr;
    private string Firmwarestr;
    public float Delay;
    public Text PasswordTEMPCHECKOK;

    public Text ButtonTextRegen;
    public Text ButtonTextAutMan;
    public Text ButtonTextECO;
    public Text ButtonTextNormal;
    public Text ButtonTextSport;
    #endregion

    #region Declare References
    //BatteryC 1-15
    private string[] batteryC = new string[22];

    //BatteryT 1-7
    private string[] batteryT = new string[7];

    //BatteryTextVerify 1 - 15
    public Text[] BatteryTextVerify = new Text[22];

    // Charge Menu Public References
    //Where to display info
    public Text chargeValue;

    //Where to enter digits
    public InputField chargeInputFieldSet;

    // Natural Regen Menu Public References
    //Where to display info
    public Text regenValue;

    //Where to enter digits
    public InputField naturalInputFieldSet;

    // FootBrake Regen Menu Public References
    //Where to display info
    public Text footBrakeValue;

    //Where to enter digits
    public InputField footInputFieldSet;
    #endregion
    
    #region Start
    // Use this for initialization 
    void Start() {
        Screen.sleepTimeout = SleepTimeout.NeverSleep;

        tuningLightBtn.onClick.AddListener(TuningSetupLight);
        tuningMediumBtn.onClick.AddListener(TuningSetupMedium);
        tuningMaxBtn.onClick.AddListener(TuningSetupSport);
        tuningOriginalBtn.onClick.AddListener(TuningSetupOriginal);
        tuningT80T45Btn.onClick.AddListener(TuningSetupT80T45);
        tuningExitBtn.onClick.AddListener(TuningSetupExit);

        batteryExitBtn.onClick.AddListener(BatteryExit);

        profileEcoBtn.onClick.AddListener(ProfileEco);
        profileNormalBtn.onClick.AddListener(ProfileNormal);
        profileSportBtn.onClick.AddListener(ProfileSport);
        profileRegenBtn.onClick.AddListener(ProfileRegen);
        ProfileAutManBtn.onClick.AddListener(ProfileAutMan);
        PBFWBtn.onClick.AddListener(PBFW);
        SetupBackBtn.onClick.AddListener(SetupBack);

        tuningBtn.onClick.AddListener(TuningPanel);
        batteryBtn.onClick.AddListener(BatteryPanel);

        uiPanel.SetActive(false); //Change to false

        txtDebug.text += "Initialising bluetooth \n";
        BluetoothLEHardwareInterface.Initialize(true, false, () => { },
                                      (error) => { }
        );

        Invoke("scan", 1f);
        isMainActive = true;
        FWVersionValue.gameObject.SetActive(false);
        txtReceive = mainInfoVerify;
        {
            InvokeRepeating("AutoUpdateMainMenu", 1f, 1.0f);
        }
    }
    #endregion
    
    #region Update 
    // Update is called once per frame 
    void Update() {
    	
        if (_readFound && _writeFound) {
            _readFound = false;
            _writeFound = false;
            _subscribingTimeout = 1.0f;
        }
		      
        if (_subscribingTimeout > 0f) {
            _subscribingTimeout -= Time.deltaTime;
            if (_subscribingTimeout <= 0f) {
                _subscribingTimeout = 0f;
                BluetoothLEHardwareInterface.SubscribeCharacteristicWithDeviceAddress(
                   _connectedID, FullUUID(_serviceUUID), FullUUID(_readCharacteristicUUID),
                   (deviceAddress, notification) => {
                   },
                   (deviceAddress2, characteristic, data) => {
                       BluetoothLEHardwareInterface.Log("id: " + _connectedID);
                       if (deviceAddress2.CompareTo(_connectedID) == 0) {
                           BluetoothLEHardwareInterface.Log(string.Format("data length: {0}", data.Length));
                           if (data.Length == 0) {
                           // do nothing 
                       }
                           else {
                               string s = ASCIIEncoding.UTF8.GetString(data);
                               BluetoothLEHardwareInterface.Log("data: " + s);
                               receiveText(s);
                           }
                       }
                   });

            }
        }
    }
    #endregion
    
    #region Button text color Update
    // Endrer fargene på Knappeteksten
    public void ChangeColourRegen()
    {
        if (strReceive == "Reg ON") {
            ButtonTextRegen.color = Color.green;
      	} else if (strReceive == "Reg OFF") {
            ButtonTextRegen.color = Color.red;        
      	}        
    }	
    public void ChangeColourAutMan()
    {
        if (strReceive == "Auto Mode") {
            ButtonTextAutMan.color = Color.green;
      	} else if (strReceive == "Manuel Mode") {
            ButtonTextAutMan.color = Color.red;        
      	}        
    }	
    public void ChangeColourECO()
    {
        if (strReceive == "ECO Profile") {
            ButtonTextECO.color = Color.green;
            ButtonTextNormal.color = Color.white;
            ButtonTextSport.color = Color.white; 
      	}       
    }	
    public void ChangeColourNormal()
    {
        if (strReceive == "Normal Profile") {
    	    ButtonTextECO.color = Color.white;
            ButtonTextNormal.color = Color.green;
            ButtonTextSport.color = Color.white;
      	}       
    }	
    public void ChangeColourSport()
    {
        if (strReceive == "Sport Profile") {
    	    ButtonTextECO.color = Color.white;
    	  	ButtonTextNormal.color = Color.white;
            ButtonTextSport.color = Color.green;
      	}       
    }	
    #endregion

		#region Auto Update
			#region Auto Update MainMenu
	void AutoUpdateMainMenu() { 
	    if (isMainActive) {
          StartCoroutine(MainManuTexUpdate()); 
      	}
	}

    public void ActivateMain() {     //  <---- Används de här?
        isMainActive = true;
    }
    	
    public void DeactivateMain() {  //  <---- Används de här?
        isMainActive = false;
    }

	IEnumerator MainManuTexUpdate() {

		 //Aktiver BLE Loop      
    	Byte ui = 0x80;
    	sendDataBluetooth(ui); 
     	yield return new WaitForSeconds(0.01f);
     	    
	}
   		#endregion 

    #endregion
    #region Setup Menu
    
    void PBFW() {
    	  FWVersionValue.gameObject.SetActive(true);
        txtReceive = FWVersionValue;
        Byte ui = 0x80;
    	  sendDataBluetooth(ui); 
    }
    void SetupBack() {
    	  FWVersionValue.gameObject.SetActive(false);
    }
    
    #endregion

    #region Tuning Menu

    void TuningPanel() {
    	tuningValue.text = "Select tuning level.";
        txtReceive = tuningValue;
        Byte ui = 0x74;
        sendDataBluetooth(ui);
    }

    void TuningSetupLight() {
        Byte ui = 0x1;
        sendDataBluetooth(ui);
    }

    void TuningSetupMedium() {
        Byte ui = 0x2;
        sendDataBluetooth(ui);
    }

    void TuningSetupSport() {
        Byte ui = 0x3;
        sendDataBluetooth(ui);
    }

    void TuningSetupOriginal() {
        Byte ui = 0x4;
        sendDataBluetooth(ui);
    }

    void TuningSetupT80T45() {
        Byte ui = 0x5;
        sendDataBluetooth(ui);
    }

    void TuningSetupExit() {
        Byte ui = 0x6;
        sendDataBluetooth(ui);
    }
    #endregion

    #region FootBrake Regen Menu
    //Set Powerbox Info Target
    public void FootBrakeInfoTarget() {
        txtReceive = footBrakeValue;
    }

    //Enter FootBrake Regen Menu
    public void FootBrakeMenuEnter() {
        Byte ui = 0x78;
        sendDataBluetooth(ui);
    }

    //Exit FootBrake Regen Menu
    public void FootBrakeMenuBack() {
        Byte ui = 0x00;
        sendDataBluetooth(ui);
    }

    //Set FootBrake Regen To 365
    public void FootBrakeSet365() {
        uint ui = 0x16D;
        sendDataBluetooth16(ui);
    }

    //Set FootBrake Regen Level
    public void FootBrakeSetLevel() {
        int valINT;
        int.TryParse(footInputFieldSet.text, out valINT);
        UInt16 ui = (UInt16)valINT;
        sendDataBluetooth16(ui);
        footInputFieldSet.text = "";
    }
    #endregion

    #region Natural Regen Menu
    //Set Powerbox Info Target
    public void NaturalRegenInfoTarget() {
        txtReceive = regenValue;
    }

    //Enter Natural Regen Menu
    public void NaturalRegenMenuEnter() {
        Byte ui = 0x77;
        sendDataBluetooth(ui);
    }

    //Exit Natural Regen Menu
    public void NaturalRegenMenuBack() {
        Byte ui = 0x00;
        sendDataBluetooth(ui);
    }

    //Set Natural Regen To 563
    public void NaturalSet563() {
        uint ui = 0x233;
        sendDataBluetooth16(ui);
    }

    //Set Natural Regen Level
    public void NaturalRegenSetLevel() {
        int valINT;
        int.TryParse(naturalInputFieldSet.text, out valINT);
        UInt16 ui = (UInt16)valINT;
        sendDataBluetooth16(ui);
        naturalInputFieldSet.text = "";
    }
    #endregion

    #region Charge Menu
    //Set Powerbox Info Target
    public void ChargeInfoTarget() {
        txtReceive = chargeValue;
    }

    //Enter Charge Menu
    public void ChargeMenuEnter() {
        Byte ui = 0x75;
        sendDataBluetooth(ui);
    }

    //Exit Charge Menu
    public void ChargeMenuBack() {
        Byte ui = 0x00;
        sendDataBluetooth(ui);
    }

    //Set Charge Level 69
    public void ChargeSet69() {
        Byte ui = 0x45;
        sendDataBluetooth(ui);
    }

    //Set Charge Level
    public void ChargeSetLevel() {
        byte valByte;
        byte.TryParse(chargeInputFieldSet.text, out valByte);
        Byte ui = (Byte)valByte;
        sendDataBluetooth(ui);
        chargeInputFieldSet.text = "";
    }
    #endregion

    #region Battery Menu
    void deliteBatteryText() {
        for (int i = 0; i < BatteryTextVerify.Length; i++) {
            BatteryTextVerify[i].text = "";
        }
    }

    void BatteryPanel() {
    	  deliteBatteryText();
    	  BatteryText17Verify.text = "";
        Byte ui = 0x7E;
        sendDataBluetooth(ui);
    }

    void BatteryExit() {
    	  isMainActive = true;
        Byte ui = 0x0;
        sendDataBluetooth(ui);
    }
    #endregion

    #region Main Menu
    void ProfileEco() {
    	  isMainActive = false;
		//  txtReceive = mainInfoVerify;
        Byte ui = 0x66;
        sendDataBluetooth(ui);
        isMainActive = true;   
    }
    void ProfileNormal() {
    	  isMainActive = false;
		//  txtReceive = mainInfoVerify;
        Byte ui = 0x67;
        sendDataBluetooth(ui);
        isMainActive = true;
    }
    void ProfileSport() {
    	  isMainActive = false;
		//  txtReceive = mainInfoVerify;
        Byte ui = 0x68;
        sendDataBluetooth(ui);
        isMainActive = true;
    }
    void ProfileRegen() {
    	  isMainActive = false;
		//  txtReceive = mainInfoVerify;
        Byte ui = 0x69;
        sendDataBluetooth(ui);
        isMainActive = true;
    } 
    void ProfileAutMan() {
    	  isMainActive = false;
		//  txtReceive = mainInfoVerify;
        Byte ui = 0x7C;
        sendDataBluetooth(ui);
        isMainActive = true;        
    } 
    #endregion

    #region Password Check
    public void PassCheck() {
		//  txtReceive = PasswordTEMPCHECKOK;
        StartCoroutine(pinCheck());        
    }
    IEnumerator pinCheck() {
        Byte ui = 0x7A;
        sendDataBluetooth(ui);

        //Wait for 0,3 seconds
        yield return new WaitForSecondsRealtime(0.3f);

        //Send 1234 ass password
        UInt16 ui16 = 1234; //UInt16 ui16 = 2586;
        sendDataBluetooth16(ui16);
    }
    #endregion

    #region Bluethoot in, out, Scan and connect
    void receiveText(string s) {

        // txtDebug.text += "Received: " + s + " \n";
        strReceive = s;
        txtReceive.text = s;

        // sjekker innkommende meldinger og vidersender  
        switch (strReceive.Substring(0,3)) {
        		case "SOC":
                SOCstr = strReceive;
                SOCVerify.text = SOCstr;
                break;
            case "SOH":
                SOHstr = strReceive;
                SOHVerify.text = SOHstr;
                break;
            case "B-T":
                bTempstr = strReceive;
                bTempVerify.text = bTempstr;
                break;
            case "M-T":
                mTempstr = strReceive;
                mTempVerify.text = mTempstr;
                break;
            case "Tun":
                Tuningstr = strReceive;
                TuningVerify.text = Tuningstr;
                break;
           case "kWh":
                kWhstr = strReceive;
                kWhVerify.text = kWhstr;
                break;
           case "Amp":
                Ampstr = strReceive;
                AmpVerify.text = Ampstr;
                break;
           case "RPM":
                RPMstr = strReceive;
                RPMVerify.text = RPMstr;
                break;
           case "Nm ":
                Nmstr = strReceive;
                NmVerify.text = Nmstr;
                break;
           case "FW ":
                Firmwarestr = strReceive;
                FirmwareVerify.text = Firmwarestr;
                break;
           case "C1:":
                batteryC[0] = strReceive;
                BatteryTextVerify[0].text = batteryC[0];
                break;
           case "C2:":
                batteryC[1] = strReceive;
                BatteryTextVerify[1].text = batteryC[1];
                break;
           case "C3:":
                batteryC[2] = strReceive;
                BatteryTextVerify[2].text = batteryC[2];
                break;
           case "C4:":
                batteryC[3] = strReceive;
                BatteryTextVerify[3].text = batteryC[3];
                break;
           case "C5:":
                batteryC[4] = strReceive;
                BatteryTextVerify[4].text = batteryC[4];
                break;
           case "C6:":
                batteryC[5] = strReceive;
                BatteryTextVerify[5].text = batteryC[5];
                break;
           case "C7:":
                batteryC[6] = strReceive;
                BatteryTextVerify[6].text = batteryC[6];
                break;
           case "C8:":
                batteryC[7] = strReceive;
                BatteryTextVerify[7].text = batteryC[7];
                break;
           case "C9:":
                batteryC[8] = strReceive;
                BatteryTextVerify[8].text = batteryC[8];
                break;
           case "C10":
                batteryC[9] = strReceive;
                BatteryTextVerify[9].text = batteryC[9];
                break;
           case "C11":
                batteryC[10] = strReceive;
                BatteryTextVerify[10].text = batteryC[10];
                break;
           case "C12":
                batteryC[11] = strReceive;
                BatteryTextVerify[11].text = batteryC[11];
                break;
           case "C13":
                batteryC[12] = strReceive;
                BatteryTextVerify[12].text = batteryC[12];
                break;
           case "C14":
                batteryC[13] = strReceive;
                BatteryTextVerify[13].text = batteryC[13];
                break;               
           case "Pac":
                batteryC[14] = strReceive;
                BatteryTextVerify[14].text = batteryC[14];
                break;              
           case "T1:":
                batteryC[15] = strReceive;
                BatteryTextVerify[15].text = batteryC[15];
                break;              
           case "T2:":
                batteryC[16] = strReceive;
                BatteryTextVerify[16].text = batteryC[16];
                break;              
           case "T3:":
                batteryC[17] = strReceive;
                BatteryTextVerify[17].text = batteryC[17];
                break;              
           case "T4:":
                batteryC[18] = strReceive;
                BatteryTextVerify[18].text = batteryC[18];
                break;              
           case "T5:":
                batteryC[19] = strReceive;
                BatteryTextVerify[19].text = batteryC[19];
                break;              
           case "T6:":
                batteryC[20] = strReceive;
                BatteryTextVerify[20].text = batteryC[20];
                break;              
           case "T7:":
                batteryC[21] = strReceive;
                BatteryTextVerify[21].text = batteryC[21];
                break;
            case "Reg":
                ChangeColourRegen();
                break;
            case "ECO":
                ChangeColourECO();
                break;
            case "Nor":
                ChangeColourNormal();
                break;
            case "Spo":
                ChangeColourSport();
                break;
            case "Aut":
                ChangeColourAutMan();
                break;
            case "Man":
                ChangeColourAutMan();
                break;
            default:
                break;
        }
    }

    void sendDataBluetooth(Byte ui) {
        byte[] bytes = BitConverter.GetBytes(ui);
        Array.Resize(ref bytes, 1);
        if (bytes.Length > 0) {
            sendBytesBluetooth(bytes);
        }
    }

    void sendDataBluetooth16(uint ui) {
        byte[] bytes = BitConverter.GetBytes(ui);
        Array.Resize(ref bytes, 2);
        if (bytes.Length > 0) {
            sendBytesBluetooth(bytes);
        }
    }

    void sendBytesBluetooth(byte[] data) {
        BluetoothLEHardwareInterface.Log(string.Format("data length: {0} uuid {1}", data.Length.ToString(), FullUUID(_writeCharacteristicUUID)));
        BluetoothLEHardwareInterface.WriteCharacteristic(_connectedID, FullUUID(_serviceUUID), FullUUID(_writeCharacteristicUUID),
           data, data.Length, true, (characteristicUUID) => {
               BluetoothLEHardwareInterface.Log("Write succeeded");
           }
        );
    }
    

    void scan() {

        // the first callback will only get called the first time this device is seen 
        // this is because it gets added to a list in the BluetoothDeviceScript 
        // after that only the second callback will get called and only if there is 
        // advertising data available 
        txtDebug.text += ("Starting scan \r\n");
        BluetoothLEHardwareInterface.ScanForPeripheralsWithServices(null, (address, name) => {
            AddPeripheral(name, address);
        }, (address, name, rssi, advertisingInfo) => { });

    }

    void AddPeripheral(string name, string address) {
        txtDebug.text += ("Found " + name + " \r\n");

        if (_peripheralList == null) {
            _peripheralList = new Dictionary<string, string>();
        }
        if (!_peripheralList.ContainsKey(address)) {
            _peripheralList[address] = name;
            if (name.Trim().ToLower() == deviceToConnectTo.Trim().ToLower()) {
                //txtDebug.text += "Found our device, stop scanning \n"; 
                //BluetoothLEHardwareInterface.StopScan (); 

                txtDebug.text += "Connecting to " + address + "\n";
                connectBluetooth(address);
            }
            else {
                txtDebug.text += "Not what we're looking for \n";
            }
        }
        else {
            txtDebug.text += "No address found \n";
        }
    }

    void connectBluetooth(string addr) {
        BluetoothLEHardwareInterface.ConnectToPeripheral(addr, (address) => {
        },
           (address, serviceUUID) => {
           },
           (address, serviceUUID, characteristicUUID) => {

             // discovered characteristic 
             if (IsEqual(serviceUUID, _serviceUUID)) {
                   _connectedID = address;
                   isConnected = true;

                   if (IsEqual(characteristicUUID, _readCharacteristicUUID)) {
                       _readFound = true;
                   }
                   if (IsEqual(characteristicUUID, _writeCharacteristicUUID)) {
                       _writeFound = true;
                   }

                   txtDebug.text += "Connected";
                   BluetoothLEHardwareInterface.StopScan();
                   uiPanel.SetActive(true);
                   connectPanel.SetActive(false);

               }
           }, (address) => {

             // this will get called when the device disconnects 
             // be aware that this will also get called when the disconnect 
             // is called above. both methods get call for the same action 
             // this is for backwards compatibility 
             isConnected = false;
           });

    }
    #endregion

    #region Helper functions
    string FullUUID(string uuid) {
        return _FullUID.Replace("****", uuid);
    }

    bool IsEqual(string uuid1, string uuid2) {
        if (uuid1.Length == 4) {
            uuid1 = FullUUID(uuid1);
        }
        if (uuid2.Length == 4) {
            uuid2 = FullUUID(uuid2);
        }
        return (uuid1.ToUpper().CompareTo(uuid2.ToUpper()) == 0);
    }
    #endregion
}