﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.UI;

public class CameraMovement : MonoBehaviour {

    private Transform cameraTransform;
    private Transform cameraDesiredLookat;
    public InputField pin;
    public GameObject regenPanel;
    public GameObject footbrakePanel;
    public GameObject batteryPanel;
    public GameObject batteryTempPanel;

    // Use this for initialization
    void Start () {
        cameraTransform = this.transform;
    }
	
	// Update is called once per frame
	void Update () {
		if (cameraDesiredLookat != null) {
            cameraTransform.rotation = Quaternion.Slerp(cameraTransform.rotation, cameraDesiredLookat.rotation, 3 * Time.deltaTime);
        }
	}

    public void exitApp() {
        Application.Quit();
    }

    public void RegenClick() {
        regenPanel.active = true;
        footbrakePanel.active = false;
    }

    public void FootbrakeClick() {
        footbrakePanel.active = true;
        regenPanel.active = false;
    }
    
    public void batteryClick() {
        batteryPanel.active = true;
        batteryTempPanel.active = false;
    }
    
    public void batteryTempClick() {
        batteryTempPanel.active = true;
        batteryPanel.active = false;
    }

    public void Pswrd() {
    }

    public void LookAtSetupMenu(Transform menuTransform) {
            cameraDesiredLookat = menuTransform;
    }

    public void LookAtMenu(Transform menuTransform) {
            cameraDesiredLookat = menuTransform;
    }
}
