/*
 * Decompiled with CFR 0.152.
 */
package com.shatalmic.unityandroidbluetoothlelib;

import android.annotation.TargetApi;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothGattCallback;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattDescriptor;
import android.bluetooth.BluetoothGattServer;
import android.bluetooth.BluetoothGattServerCallback;
import android.bluetooth.BluetoothGattService;
import android.bluetooth.BluetoothManager;
import android.bluetooth.le.AdvertiseCallback;
import android.bluetooth.le.AdvertiseData;
import android.bluetooth.le.AdvertiseSettings;
import android.bluetooth.le.BluetoothLeAdvertiser;
import android.bluetooth.le.BluetoothLeScanner;
import android.bluetooth.le.ScanCallback;
import android.bluetooth.le.ScanFilter;
import android.bluetooth.le.ScanResult;
import android.bluetooth.le.ScanSettings;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Build;
import android.os.ParcelUuid;
import android.os.Parcelable;
import android.util.Base64;
import android.util.Log;
import com.unity3d.player.UnityPlayer;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;

public class UnityBluetoothLE {
    public static UnityBluetoothLE _instance;
    public static final String TAG = "UnityBluetoothLE";
    public AtomicBoolean mRunning = new AtomicBoolean();
    private BluetoothAdapter mBluetoothAdapter;
    private BluetoothLeScanner mBluetoothLeScanner;
    private BluetoothLeAdvertiser mBluetoothAdvertiser;
    private ArrayList<UUID> uuidList = null;
    private Map<String, BluetoothDevice> deviceMap = null;
    private Map<String, BluetoothGatt> deviceGattMap = null;
    private Context mContext = null;
    private final BroadcastReceiver ActionFoundReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if ("android.bluetooth.device.action.UUID".equals(action)) {
                UnityBluetoothLE.this.androidBluetoothLog("got action_uuid");
                if (UnityBluetoothLE.this.uuidList != null) {
                    BluetoothDevice device = (BluetoothDevice)intent.getParcelableExtra("android.bluetooth.device.extra.DEVICE");
                    Parcelable[] uuidExtra = intent.getParcelableArrayExtra("android.bluetooth.device.extra.UUID");
                    if (device != null && uuidExtra != null) {
                        for (Parcelable uuidParcel : uuidExtra) {
                            String uuid = uuidParcel.toString();
                            UnityBluetoothLE.this.androidBluetoothLog("checking uuid " + uuid);
                            if (!UnityBluetoothLE.this.uuidList.contains(UnityBluetoothLE.this.getFullBluetoothLEUUID(uuid))) continue;
                            UnityBluetoothLE.this.sendDiscoveredDevice(device, 0, null, "");
                        }
                    } else {
                        if (device != null) {
                            UnityBluetoothLE.this.androidBluetoothLog("device: " + device.getAddress());
                        } else {
                            UnityBluetoothLE.this.androidBluetoothLog("device is null");
                        }
                        if (uuidExtra != null) {
                            UnityBluetoothLE.this.androidBluetoothLog("uuid count: " + uuidExtra.length);
                        } else {
                            UnityBluetoothLE.this.androidBluetoothLog("uuidExtra is null");
                        }
                    }
                }
            }
        }
    };
    private int _scanMode = 1;
    private int _matchMode = 2;
    private int _connectionPriority = 0;
    private boolean _noManufacturerData = false;
    private int _recordType = 255;
    private BluetoothAdapter.LeScanCallback mLeScanCallback = new BluetoothAdapter.LeScanCallback(){

        public void onLeScan(BluetoothDevice device, int rssi, byte[] scanRecord) {
            UnityBluetoothLE.this.sendDiscoveredDevice(device, rssi, scanRecord, "");
        }
    };
    private ScanCallback api21ScanCallback;
    private final BluetoothGattCallback mGattCallback = new BluetoothGattCallback(){

        public void onConnectionStateChange(BluetoothGatt gatt, int status, int newState) {
            UnityBluetoothLE.this.androidBluetoothLog("onConnectionStateChange");
            String deviceAddress = gatt.getDevice().getAddress();
            if (newState == 2) {
                if (UnityBluetoothLE.this.deviceGattMap == null) {
                    UnityBluetoothLE.this.deviceGattMap = new HashMap();
                }
                UnityBluetoothLE.this.deviceGattMap.put(deviceAddress, gatt);
                UnityBluetoothLE.UnitySend("ConnectedPeripheral~" + deviceAddress);
                gatt.discoverServices();
            } else if (newState == 0) {
                gatt.close();
                UnityBluetoothLE.UnitySend("DisconnectedPeripheral~" + deviceAddress);
            }
        }

        public void onServicesDiscovered(BluetoothGatt gatt, int status) {
            if (status == 0) {
                List services;
                UnityBluetoothLE.this.androidBluetoothLog("Services Discovered");
                if (Build.VERSION.SDK_INT >= 21) {
                    gatt.requestConnectionPriority(UnityBluetoothLE.this._connectionPriority);
                }
                if ((services = gatt.getServices()) != null) {
                    String deviceAddress = gatt.getDevice().getAddress();
                    for (BluetoothGattService service : services) {
                        UnityBluetoothLE.UnitySend("DiscoveredService~" + deviceAddress + "~" + service.getUuid());
                        List characteristics = service.getCharacteristics();
                        for (BluetoothGattCharacteristic characteristic : characteristics) {
                            UnityBluetoothLE.UnitySend("DiscoveredCharacteristic~" + deviceAddress + "~" + service.getUuid() + "~" + characteristic.getUuid());
                        }
                    }
                }
            } else {
                UnityBluetoothLE.this.androidBluetoothLog("Error~Service Discovery " + status);
            }
        }

        public void onCharacteristicRead(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic, int status) {
            byte[] data;
            if (status == 0 && (data = characteristic.getValue()) != null) {
                String deviceAddress = gatt.getDevice().getAddress();
                String dataString = Base64.encodeToString((byte[])data, (int)0);
                UnityBluetoothLE.UnitySend("DidUpdateValueForCharacteristic~" + deviceAddress + "~" + characteristic.getUuid() + "~" + dataString);
            }
        }

        public void onCharacteristicChanged(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic) {
            byte[] data = characteristic.getValue();
            if (data != null) {
                String deviceAddress = gatt.getDevice().getAddress();
                String dataString = Base64.encodeToString((byte[])data, (int)0);
                UnityBluetoothLE.UnitySend("DidUpdateValueForCharacteristic~" + deviceAddress + "~" + characteristic.getUuid() + "~" + dataString);
            }
        }

        public void onCharacteristicWrite(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic, int status) {
            if (status == 0) {
                UnityBluetoothLE.UnitySend("DidWriteCharacteristic~" + characteristic.getUuid());
            } else {
                UnityBluetoothLE.UnitySend("Error~Response - failed to write characteristic: " + status);
            }
        }

        public void onDescriptorWrite(BluetoothGatt gatt, BluetoothGattDescriptor descriptor, int status) {
            if (status == 0) {
                UnityBluetoothLE.this.androidBluetoothLog("onDescriptorWrite Success");
                if (descriptor != null && descriptor.getCharacteristic() != null && descriptor.getCharacteristic().getUuid() != null) {
                    String deviceAddress = gatt.getDevice().getAddress();
                    UnityBluetoothLE.UnitySend("DidUpdateNotificationStateForCharacteristic~" + deviceAddress + "~" + descriptor.getCharacteristic().getUuid());
                } else {
                    UnityBluetoothLE.UnitySend("Error~Descriptor Write Failed: characterstic or uuid blank");
                }
            } else {
                UnityBluetoothLE.UnitySend("Error~Descriptor Write Failed: " + status);
            }
        }
    };
    protected static final UUID CHARACTERISTIC_UPDATE_NOTIFICATION_DESCRIPTOR_UUID;
    private AdvertiseCallback advertisingCallback = null;
    private String primaryServiceUUID = "";
    private ArrayList<BluetoothGattCharacteristic> characteristList = null;
    private ArrayList<ServiceCharacteristicMap> serviceList = null;
    private BluetoothGattServer mBluetoothGattServer = null;
    private UnityGattServices mUnityGattServices = null;
    private Map<UUID, ArrayList<BluetoothDevice>> notifyDeviceMap = null;
    private String notificationDescriptionUUID = "00002902-0000-1000-8000-00805f9b34fb";

    public static UnityBluetoothLE getInstance() {
        if (_instance == null) {
            _instance = new UnityBluetoothLE();
        }
        return _instance;
    }

    public static void UnitySend(String message) {
        UnityPlayer.UnitySendMessage((String)"BluetoothLEReceiver", (String)"OnBluetoothMessage", (String)message);
    }

    public static void UnitySend(byte[] data, int length) {
        String message = Base64.encodeToString((byte[])Arrays.copyOfRange(data, 0, length), (int)0);
        UnityPlayer.UnitySendMessage((String)"BluetoothLEReceiver", (String)"OnBluetoothData", (String)message);
    }

    public static void UnitySendPeripheral(byte[] data, int length) {
        String message = Base64.encodeToString((byte[])Arrays.copyOfRange(data, 0, length), (int)0);
        UnityPlayer.UnitySendMessage((String)"BluetoothLEReceiver", (String)"OnPeripheralData", (String)message);
    }

    private UUID getFullBluetoothLEUUID(String uuidString) {
        this.androidBluetoothLog("getFullBluetoothLEUUID : " + uuidString);
        UUID uuid = uuidString.length() == 4 ? UUID.fromString("0000" + uuidString + "-0000-1000-8000-00805F9B34FB") : UUID.fromString(uuidString);
        return uuid;
    }

    private UUID getUUIDFromString(String uuidString) {
        String s2 = uuidString.replace("-", "");
        UUID uuid = new UUID(new BigInteger(s2.substring(0, 16), 16).longValue(), new BigInteger(s2.substring(16), 16).longValue());
        return uuid;
    }

    public void androidBluetoothInitialize(boolean asCentral, boolean asPeripheral) {
        Log.d((String)TAG, (String)"androidBluetoothInitialize");
        this.mContext = UnityPlayer.currentActivity.getApplicationContext();
        if (!this.mContext.getPackageManager().hasSystemFeature("android.hardware.bluetooth_le")) {
            UnityBluetoothLE.UnitySend("Error~Bluetooth Low Energy Not Available");
        } else {
            this.uuidList = null;
            this.deviceMap = null;
            this.deviceGattMap = null;
            IntentFilter filter = new IntentFilter("android.bluetooth.device.action.FOUND");
            filter.addAction("android.bluetooth.device.action.UUID");
            filter.addAction("android.bluetooth.adapter.action.DISCOVERY_STARTED");
            filter.addAction("android.bluetooth.adapter.action.DISCOVERY_FINISHED");
            this.mContext.registerReceiver(this.ActionFoundReceiver, filter);
            if (BluetoothAdapter.getDefaultAdapter() != null) {
                if (asPeripheral && Build.VERSION.SDK_INT < 21 || asPeripheral && Build.VERSION.SDK_INT >= 21 && BluetoothAdapter.getDefaultAdapter().getBluetoothLeAdvertiser() == null) {
                    UnityBluetoothLE.UnitySend("Error~Peripheral mode is Not Available");
                } else {
                    BluetoothManager bluetoothManager = (BluetoothManager)this.mContext.getSystemService("bluetooth");
                    if (bluetoothManager != null) {
                        this.mBluetoothAdapter = bluetoothManager.getAdapter();
                        if (this.mBluetoothAdapter != null) {
                            if (this.mBluetoothAdapter.isEnabled()) {
                                if (Build.VERSION.SDK_INT >= 21) {
                                    this.mBluetoothLeScanner = this.mBluetoothAdapter.getBluetoothLeScanner();
                                }
                                UnityBluetoothLE.UnitySend("Initialized");
                            } else {
                                UnityBluetoothLE.UnitySend("Error~Bluetooth LE Not Enabled");
                            }
                        } else {
                            this.onDestroy();
                        }
                    } else {
                        this.onDestroy();
                    }
                }
            } else {
                UnityBluetoothLE.UnitySend("Error~Bluetooth LE Not Available");
            }
        }
    }

    public void androidBluetoothScanMode(int scanMode) {
        switch (scanMode) {
            case 0: {
                this._scanMode = 0;
                break;
            }
            case 1: {
                this._scanMode = 1;
                break;
            }
            case 2: {
                this._scanMode = 2;
            }
        }
    }

    public void androidBluetoothConnectionPriority(int connectionPriority) {
        switch (connectionPriority) {
            case 0: {
                this._connectionPriority = 2;
                break;
            }
            case 1: {
                this._connectionPriority = 0;
                break;
            }
            case 2: {
                this._connectionPriority = 1;
            }
        }
    }

    public void androidBluetoothLog(String message) {
        Log.i((String)TAG, (String)message);
    }

    public void androidBluetoothDeInitialize() {
        Log.d((String)TAG, (String)"androidBluetoothDeInitialize");
        this.onDestroy();
        UnityBluetoothLE.UnitySend("DeInitialized");
    }

    public void androidBluetoothEnable(boolean enable) {
        this.androidBluetoothLog("androidBluetoothEnable");
        if (this.mBluetoothAdapter == null) {
            UnityBluetoothLE.UnitySend("Error~Plugin Initialize not called.");
        } else if (enable) {
            this.mBluetoothAdapter.enable();
        } else {
            this.mBluetoothAdapter.disable();
        }
    }

    public void onDestroy() {
        if (this.mContext != null) {
            this.mContext.unregisterReceiver(this.ActionFoundReceiver);
            this.uuidList = null;
            this.deviceMap = null;
            this.deviceGattMap = null;
        }
    }

    private void sendDiscoveredDevice(BluetoothDevice device, int rssi, byte[] scanRecord, String identifier) {
        String name = "No Name";
        if (device.getName() != null) {
            name = device.getName();
        }
        if (this.deviceMap == null) {
            this.deviceMap = new HashMap<String, BluetoothDevice>();
        }
        this.deviceMap.put(device.getAddress(), device);
        if (this._noManufacturerData) {
            byte[] manufacturerBytes = null;
            if (scanRecord != null) {
                AdRecordList recordList = new AdRecordList();
                recordList.parseScanRecord(scanRecord);
                AdRecord record = recordList.getRecord(this._recordType);
                if (record != null) {
                    manufacturerBytes = record.Data;
                }
            }
            if (manufacturerBytes != null || rssi != 0) {
                if (manufacturerBytes == null) {
                    manufacturerBytes = new byte[]{0};
                }
                UnityBluetoothLE.UnitySend("DiscoveredPeripheral~" + device.getAddress() + "~" + name + "~" + Integer.valueOf(rssi) + "~" + Base64.encodeToString((byte[])manufacturerBytes, (int)0));
            } else {
                UnityBluetoothLE.UnitySend("DiscoveredPeripheral~" + device.getAddress() + "~" + name);
            }
        } else if (scanRecord != null) {
            AdRecordList recordList = new AdRecordList();
            recordList.parseScanRecord(scanRecord);
            AdRecord record = recordList.getRecord(-1);
            if (record != null) {
                UnityBluetoothLE.UnitySend("DiscoveredPeripheral~" + device.getAddress() + "~" + name + "~" + Integer.valueOf(rssi) + "~" + Base64.encodeToString((byte[])record.Data, (int)0));
            } else {
                UnityBluetoothLE.UnitySend("DiscoveredPeripheral~" + device.getAddress() + "~" + name);
            }
        } else {
            UnityBluetoothLE.UnitySend("DiscoveredPeripheral~" + device.getAddress() + "~" + name);
        }
    }

    public void androidBluetoothPause(boolean paused) {
    }

    public static String byteArrayToHexString(byte[] array) {
        StringBuffer hexString = new StringBuffer();
        for (byte b : array) {
            int intVal = b & 0xFF;
            if (intVal < 16) {
                hexString.append("0");
            }
            hexString.append(Integer.toHexString(intVal));
        }
        return hexString.toString().toUpperCase();
    }

    @TargetApi(value=23)
    private void api21Scan(List<UUID> uuids, List<String> beaconList) {
        ScanCallback scanCallback;
        final boolean beaconScan = beaconList != null;
        ArrayList<ScanFilter> scanFilters = new ArrayList<ScanFilter>();
        if (uuids != null && !beaconScan) {
            for (int i = 0; i < uuids.size(); ++i) {
                scanFilters.add(new ScanFilter.Builder().setServiceUuid(ParcelUuid.fromString((String)uuids.get(i).toString())).build());
            }
        }
        final HashMap<String, String> beaconIdentifiers = new HashMap<String, String>();
        if (beaconScan) {
            for (int i = 0; i < beaconList.size(); ++i) {
                String[] parts = beaconList.get(i).split(":");
                if (parts == null || parts.length != 2) continue;
                beaconIdentifiers.put(parts[0].replace("-", "").toUpperCase(), parts[1]);
                this.androidBluetoothLog("******** scanning for: " + parts[0].replace("-", "").toUpperCase());
            }
        }
        Log.i((String)TAG, (String)("Scan mode: " + this._scanMode));
        ScanSettings settings = new ScanSettings.Builder().setCallbackType(1).setScanMode(this._scanMode).build();
        this.api21ScanCallback = scanCallback = new ScanCallback(){

            public void onScanResult(int callbackType, ScanResult result) {
                if (beaconScan) {
                    byte[] proximityBytes;
                    String proximityUUID;
                    byte[] bytes = result.getScanRecord().getManufacturerSpecificData(76);
                    if (bytes != null && bytes.length == 23 && bytes[0] == 2 && bytes[1] == 21 && beaconIdentifiers.containsKey(proximityUUID = UnityBluetoothLE.byteArrayToHexString(proximityBytes = Arrays.copyOfRange(bytes, 2, 18)))) {
                        Integer major = bytes[18] << 8 | bytes[19];
                        Integer minor = bytes[20] << 8 | bytes[21];
                        Integer signalPower = bytes[22];
                        UnityBluetoothLE.UnitySend("DiscoveredBeacon~" + proximityUUID + "~" + major + "~" + minor + "~" + Integer.valueOf(result.getRssi()) + "~" + signalPower + "~unknown");
                    }
                } else {
                    UnityBluetoothLE.this.mLeScanCallback.onLeScan(result.getDevice(), result.getRssi(), result.getScanRecord().getBytes());
                }
            }

            public void onBatchScanResults(List<ScanResult> results) {
                for (ScanResult sr : results) {
                    UnityBluetoothLE.this.mLeScanCallback.onLeScan(sr.getDevice(), sr.getRssi(), sr.getScanRecord().getBytes());
                }
            }
        };
        if (uuids != null && !beaconScan) {
            this.mBluetoothAdapter.getBluetoothLeScanner().startScan(scanFilters, settings, scanCallback);
        } else {
            this.mBluetoothAdapter.getBluetoothLeScanner().startScan(null, settings, scanCallback);
        }
    }

    public void androidBluetoothScanForPeripheralsWithServices(String serviceUUIDsString, boolean rssiOnly, int recordType) {
        this._noManufacturerData = rssiOnly;
        this._recordType = recordType;
        if (this.mBluetoothAdapter != null) {
            int i;
            ArrayList<UUID> uuidList = new ArrayList<UUID>();
            if (serviceUUIDsString != null) {
                if (serviceUUIDsString.contains("|")) {
                    this.androidBluetoothLog("serviceUUIDsString : " + serviceUUIDsString);
                    String[] serviceUUIDs = serviceUUIDsString.split("\\|");
                    if (serviceUUIDs != null && serviceUUIDs.length > 0) {
                        for (i = 0; i < serviceUUIDs.length; ++i) {
                            this.androidBluetoothLog("serviceUUID : " + serviceUUIDs[i]);
                            if (serviceUUIDs[i] == null || serviceUUIDs[i].length() < 4) continue;
                            uuidList.add(this.getFullBluetoothLEUUID(serviceUUIDs[i]));
                        }
                    }
                } else if (serviceUUIDsString.length() > 0) {
                    uuidList.add(this.getFullBluetoothLEUUID(serviceUUIDsString));
                }
            }
            if (uuidList.size() > 0) {
                UUID[] uuids = new UUID[uuidList.size()];
                uuids = uuidList.toArray(uuids);
                for (i = 0; i < uuids.length; ++i) {
                    this.androidBluetoothLog("Scanning for: " + uuids[i].toString());
                }
                if (Build.VERSION.SDK_INT >= 21) {
                    this.androidBluetoothLog("Using api21scan");
                    this.api21Scan(uuidList, null);
                } else {
                    this.androidBluetoothLog("Using legacy scan");
                    this.mBluetoothAdapter.startLeScan(uuids, this.mLeScanCallback);
                }
            } else if (Build.VERSION.SDK_INT >= 21) {
                this.androidBluetoothLog("Using api21scan");
                this.api21Scan(uuidList, null);
            } else {
                this.androidBluetoothLog("Using legacy scan");
                this.mBluetoothAdapter.startLeScan(this.mLeScanCallback);
            }
        }
    }

    @TargetApi(value=21)
    private void api21StopScan() {
        if (this.api21ScanCallback != null) {
            this.mBluetoothAdapter.getBluetoothLeScanner().stopScan(this.api21ScanCallback);
        }
    }

    public void androidBluetoothStopScan() {
        if (this.mBluetoothAdapter != null) {
            if (Build.VERSION.SDK_INT >= 21) {
                this.api21StopScan();
            } else {
                this.mBluetoothAdapter.stopLeScan(this.mLeScanCallback);
            }
        }
    }

    public void androidBluetoothScanForBeacons(String proximityUUIDsString) {
        if (this.mBluetoothAdapter != null) {
            ArrayList<String> uuidList = new ArrayList<String>();
            if (proximityUUIDsString != null && (proximityUUIDsString.contains("|") || proximityUUIDsString.contains(":"))) {
                this.androidBluetoothLog("proximityUUIDsString : " + proximityUUIDsString);
                String[] proximityUUIDs = proximityUUIDsString.split("\\|");
                if (proximityUUIDs != null && proximityUUIDs.length > 0) {
                    for (int i = 0; i < proximityUUIDs.length; ++i) {
                        this.androidBluetoothLog("proximityUUIDs : " + proximityUUIDs[i]);
                        if (proximityUUIDs[i] == null || proximityUUIDs[i].length() < 4) continue;
                        uuidList.add(proximityUUIDs[i]);
                    }
                } else {
                    uuidList.add(proximityUUIDsString);
                }
            }
            if (uuidList.size() > 0 && Build.VERSION.SDK_INT >= 21) {
                this.api21Scan(null, uuidList);
            }
        }
    }

    public void androidBluetoothStopBeaconScan() {
        if (this.mBluetoothAdapter != null) {
            if (Build.VERSION.SDK_INT >= 21) {
                this.api21StopScan();
            } else {
                this.mBluetoothAdapter.stopLeScan(this.mLeScanCallback);
            }
        }
    }

    public void androidBluetoothRetrieveListOfPeripheralsWithServices(String serviceUUIDsString) {
        if (this.mBluetoothAdapter != null) {
            this.uuidList = new ArrayList();
            if (serviceUUIDsString.contains("|")) {
                String[] serviceUUIDs = serviceUUIDsString.split("|");
                if (serviceUUIDs != null && serviceUUIDs.length > 0) {
                    for (int i = 0; i < serviceUUIDs.length; ++i) {
                        this.uuidList.add(this.getFullBluetoothLEUUID(serviceUUIDs[i]));
                    }
                }
            } else if (serviceUUIDsString.length() > 0) {
                this.uuidList.add(this.getFullBluetoothLEUUID(serviceUUIDsString));
            }
            this.androidBluetoothLog("getting bonded devices");
            UnityPlayer.currentActivity.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    Set deviceSet = UnityBluetoothLE.this.mBluetoothAdapter.getBondedDevices();
                    if (deviceSet != null && deviceSet.size() > 0) {
                        for (BluetoothDevice device : deviceSet) {
                            if (device == null) continue;
                            UnityBluetoothLE.this.androidBluetoothLog("got device " + device.getAddress());
                            if (UnityBluetoothLE.this.uuidList.size() > 0) {
                                device.fetchUuidsWithSdp();
                                continue;
                            }
                            UnityBluetoothLE.this.sendDiscoveredDevice(device, 0, null, "");
                        }
                    }
                }
            });
        }
    }

    public void androidBluetoothConnectToPeripheral(String name) {
        BluetoothDevice device;
        if (this.mBluetoothAdapter != null && this.deviceMap != null && this.mContext != null && (device = this.deviceMap.get(name)) != null) {
            UnityPlayer.currentActivity.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    device.connectGatt(UnityBluetoothLE.this.mContext, false, UnityBluetoothLE.this.mGattCallback);
                }
            });
        }
    }

    public void androidBluetoothDisconnectPeripheral(String name) {
        BluetoothGatt gatt;
        if (this.mBluetoothAdapter != null && this.deviceGattMap != null && this.mContext != null && (gatt = this.deviceGattMap.get(name)) != null) {
            gatt.disconnect();
        }
    }

    protected UUID getUUID(String uuidString) {
        UUID uuid = null;
        if (uuidString.length() == 36) {
            uuid = UUID.fromString(uuidString);
        } else if (uuidString.length() <= 8) {
            StringBuilder newString = new StringBuilder();
            newString.append("00000000", 0, 8 - uuidString.length());
            newString.append(uuidString);
            newString.append("-0000-1000-8000-00805f9b34fb");
            uuid = UUID.fromString(newString.toString());
        }
        return uuid;
    }

    public void androidReadCharacteristic(String name, String serviceString, String characteristicString) {
        BluetoothGatt gatt;
        if (this.mBluetoothAdapter != null && this.deviceGattMap != null && this.mContext != null && (gatt = this.deviceGattMap.get(name)) != null) {
            UUID serviceUUID = this.getUUID(serviceString);
            if (serviceUUID != null) {
                BluetoothGattService service = gatt.getService(serviceUUID);
                if (service != null) {
                    UUID characteristicUUID = this.getUUID(characteristicString);
                    if (characteristicUUID != null) {
                        BluetoothGattCharacteristic characteristic = service.getCharacteristic(characteristicUUID);
                        if (characteristic != null) {
                            if (!gatt.readCharacteristic(characteristic)) {
                                UnityBluetoothLE.UnitySend("Error~Failed to read characteristic");
                            }
                        } else {
                            UnityBluetoothLE.UnitySend("Error~Characteristic not found for Read");
                        }
                    } else {
                        UnityBluetoothLE.UnitySend("Error~Not a Valid Characteristic UUID for Read");
                    }
                } else {
                    UnityBluetoothLE.UnitySend("Error~Service not found for Read");
                }
            } else {
                UnityBluetoothLE.UnitySend("Error~Not a Valid Service UUID for Read");
            }
        }
    }

    public void androidWriteCharacteristic(String name, String serviceString, String characteristicString, byte[] data, int length, boolean withResponse) {
        BluetoothGatt gatt;
        if (this.mBluetoothAdapter != null && this.deviceGattMap != null && this.mContext != null && (gatt = this.deviceGattMap.get(name)) != null) {
            UUID serviceUUID = this.getUUID(serviceString);
            if (serviceUUID != null) {
                BluetoothGattService service = gatt.getService(serviceUUID);
                if (service != null) {
                    UUID characteristicUUID = this.getUUID(characteristicString);
                    if (characteristicUUID != null) {
                        BluetoothGattCharacteristic characteristic = service.getCharacteristic(characteristicUUID);
                        if (characteristic != null) {
                            this.androidBluetoothLog("write characteristic");
                            characteristic.setValue(data);
                            characteristic.setWriteType(withResponse ? 2 : 1);
                            if (!gatt.writeCharacteristic(characteristic)) {
                                UnityBluetoothLE.UnitySend("Error~Failed to write characteristic");
                            }
                        } else {
                            UnityBluetoothLE.UnitySend("Error~Characteristic not found for Write");
                        }
                    } else {
                        UnityBluetoothLE.UnitySend("Error~Not a Valid Characteristic UUID for Write");
                    }
                } else {
                    UnityBluetoothLE.UnitySend("Error~Service not found for Write");
                }
            } else {
                UnityBluetoothLE.UnitySend("Error~Not a Valid Service UUID for Write");
            }
        }
    }

    protected void androidSetCharacteristicNotification(String name, String serviceString, String characteristicString, boolean enabled) {
        BluetoothGatt gatt;
        if (this.mBluetoothAdapter != null && this.deviceGattMap != null && this.mContext != null && (gatt = this.deviceGattMap.get(name)) != null) {
            UUID serviceUUID = this.getUUID(serviceString);
            if (serviceUUID != null) {
                BluetoothGattService service = gatt.getService(serviceUUID);
                if (service != null) {
                    UUID characteristicUUID = this.getUUID(characteristicString);
                    if (characteristicUUID != null) {
                        BluetoothGattCharacteristic characteristic = service.getCharacteristic(characteristicUUID);
                        if (characteristic != null) {
                            if (gatt.setCharacteristicNotification(characteristic, true)) {
                                BluetoothGattDescriptor descriptor = characteristic.getDescriptor(CHARACTERISTIC_UPDATE_NOTIFICATION_DESCRIPTOR_UUID);
                                if (descriptor != null) {
                                    int characteristicProperties = characteristic.getProperties();
                                    byte[] valueToSend = BluetoothGattDescriptor.DISABLE_NOTIFICATION_VALUE;
                                    if (enabled) {
                                        if ((characteristicProperties & 0x10) == 16) {
                                            valueToSend = BluetoothGattDescriptor.ENABLE_NOTIFICATION_VALUE;
                                        } else if ((characteristicProperties & 0x20) == 32) {
                                            valueToSend = BluetoothGattDescriptor.ENABLE_INDICATION_VALUE;
                                        }
                                    }
                                    if (valueToSend.length > 0) {
                                        this.androidBluetoothLog("Notification Description: " + valueToSend[0]);
                                        descriptor.setValue(valueToSend);
                                        if (!gatt.writeDescriptor(descriptor)) {
                                            UnityBluetoothLE.UnitySend("Error~Failed to write characteristic descriptor");
                                        } else {
                                            this.androidBluetoothLog("Notification setup succeeded");
                                        }
                                    } else {
                                        UnityBluetoothLE.UnitySend("Error~Failed to set notification type");
                                    }
                                } else {
                                    UnityBluetoothLE.UnitySend("Error~Failed to get notification descriptor");
                                }
                            } else {
                                UnityBluetoothLE.UnitySend("Error~Failed to set characteristic notification");
                            }
                        } else {
                            UnityBluetoothLE.UnitySend("Error~Characteristic not found for Subscribe");
                        }
                    } else {
                        UnityBluetoothLE.UnitySend("Error~Not a Valid Characteristic UUID for Subscribe");
                    }
                } else {
                    UnityBluetoothLE.UnitySend("Error~Service not found for Subscribe");
                }
            } else {
                UnityBluetoothLE.UnitySend("Error~Not a Valid Service UUID for Subscribe");
            }
        }
    }

    public void androidSubscribeCharacteristic(String name, String serviceString, String characteristicString) {
        this.androidBluetoothLog("subscribe characteristic");
        this.androidSetCharacteristicNotification(name, serviceString, characteristicString, true);
    }

    public void androidUnsubscribeCharacteristic(String name, String serviceString, String characteristicString) {
        this.androidBluetoothLog("unsubscribe characteristic");
        this.androidSetCharacteristicNotification(name, serviceString, characteristicString, false);
    }

    public void androidBluetoothDisconnectAll() {
        if (this.mBluetoothAdapter != null && this.deviceGattMap != null && this.mContext != null) {
            for (String key : this.deviceGattMap.keySet()) {
                BluetoothGatt gatt = this.deviceGattMap.get(key);
                if (gatt == null) continue;
                gatt.disconnect();
            }
        }
    }

    public void androidPeripheralName(String newName) {
        this.mBluetoothAdapter.setName(newName);
    }

    public void androidCreateService(String uuid, boolean primary) {
        uuid = uuid.toLowerCase();
        BluetoothGattService service = new BluetoothGattService(UUID.fromString(uuid), primary ? 0 : 1);
        if (primary) {
            this.primaryServiceUUID = uuid;
        }
        if (service != null) {
            if (this.serviceList == null) {
                this.serviceList = new ArrayList();
            }
            ServiceCharacteristicMap serviceCharacteristicMap = new ServiceCharacteristicMap();
            serviceCharacteristicMap.UUID = uuid;
            serviceCharacteristicMap.Service = service;
            serviceCharacteristicMap.characteristicMap = new HashMap<String, BluetoothGattCharacteristic>();
            for (int i = 0; i < this.characteristList.size(); ++i) {
                serviceCharacteristicMap.characteristicMap.put(this.characteristList.get(i).getUuid().toString(), this.characteristList.get(i));
                serviceCharacteristicMap.Service.addCharacteristic(this.characteristList.get(i));
            }
            this.serviceList.add(serviceCharacteristicMap);
            this.characteristList.clear();
        } else {
            UnityBluetoothLE.UnitySend("Error~Cannot create Gatt Service object while creating a service");
        }
    }

    private ServiceCharacteristicMap findService(String uuid) {
        ServiceCharacteristicMap serviceCharacteristicMap = null;
        if (this.serviceList != null) {
            uuid = uuid.toLowerCase();
            for (int i = 0; i < this.serviceList.size(); ++i) {
                if (this.serviceList.get((int)i).UUID.compareTo(uuid) != 0) continue;
                serviceCharacteristicMap = this.serviceList.get(i);
                break;
            }
        }
        return serviceCharacteristicMap;
    }

    private BluetoothGattCharacteristic findCharacteristic(String uuid) {
        BluetoothGattCharacteristic characteristic = null;
        if (this.serviceList != null) {
            uuid = uuid.toLowerCase();
            for (int i = 0; i < this.serviceList.size(); ++i) {
                if (this.serviceList.get((int)i).characteristicMap == null || !this.serviceList.get((int)i).characteristicMap.containsKey(uuid)) continue;
                characteristic = this.serviceList.get((int)i).characteristicMap.get(uuid);
                break;
            }
        }
        return characteristic;
    }

    public void androidRemoveService(String uuid) {
        ServiceCharacteristicMap serviceCharacteristicMap;
        if (this.serviceList != null && (serviceCharacteristicMap = this.findService(uuid)) != null) {
            this.serviceList.remove(serviceCharacteristicMap);
        }
    }

    public void androidRemoveServices() {
        this.serviceList = null;
    }

    public void androidCreateCharacteristic(String uuid, int properties, int permissions, byte[] data, int length) {
        uuid = uuid.toLowerCase();
        if (this.characteristList == null) {
            this.characteristList = new ArrayList();
        }
        this.androidRemoveCharacteristic(uuid);
        BluetoothGattCharacteristic gattCharacteristic = new BluetoothGattCharacteristic(UUID.fromString(uuid), properties, permissions);
        if ((permissions & 0x10) == 16) {
            BluetoothGattDescriptor gattDescriptor = new BluetoothGattDescriptor(UUID.fromString(this.notificationDescriptionUUID), 17);
            gattCharacteristic.addDescriptor(gattDescriptor);
        }
        gattCharacteristic.setValue(data);
        this.characteristList.add(gattCharacteristic);
    }

    public void androidRemoveCharacteristic(String uuid) {
        if (this.characteristList != null) {
            uuid = uuid.toLowerCase();
            for (int i = 0; i < this.characteristList.size(); ++i) {
                if (this.characteristList.get(i).getUuid().compareTo(UUID.fromString(uuid)) != 0) continue;
                this.characteristList.remove(i);
                break;
            }
        }
    }

    public void androidRemoveCharacteristics() {
        this.characteristList = null;
    }

    public void androidStartAdvertising() {
        if (Build.VERSION.SDK_INT >= 21) {
            BluetoothManager bluetoothManager;
            if (this.mBluetoothAdvertiser == null) {
                this.mBluetoothAdvertiser = this.mBluetoothAdapter.getBluetoothLeAdvertiser();
            }
            if (this.mBluetoothGattServer == null && (bluetoothManager = (BluetoothManager)this.mContext.getSystemService("bluetooth")) != null) {
                this.mUnityGattServices = new UnityGattServices();
                this.mBluetoothGattServer = bluetoothManager.openGattServer(this.mContext, (BluetoothGattServerCallback)this.mUnityGattServices);
                this.mUnityGattServices.setupServices(this.mBluetoothGattServer, this.serviceList);
            }
            AdvertiseSettings settings = new AdvertiseSettings.Builder().setAdvertiseMode(1).setTxPowerLevel(2).setConnectable(true).build();
            ParcelUuid pUuid = new ParcelUuid(UUID.fromString(this.primaryServiceUUID));
            AdvertiseData data = new AdvertiseData.Builder().setIncludeDeviceName(true).build();
            this.advertisingCallback = new AdvertiseCallback(){

                public void onStartSuccess(AdvertiseSettings settingsInEffect) {
                    super.onStartSuccess(settingsInEffect);
                    UnityBluetoothLE.UnitySend("StartedAdvertising");
                }

                public void onStartFailure(int errorCode) {
                    super.onStartFailure(errorCode);
                    UnityBluetoothLE.UnitySend("Error~Advertising onStartFailure: " + errorCode);
                }
            };
            this.mBluetoothAdvertiser = this.mBluetoothAdapter.getBluetoothLeAdvertiser();
            this.mBluetoothAdvertiser.startAdvertising(settings, data, this.advertisingCallback);
        } else {
            UnityBluetoothLE.UnitySend("Error~Failed to start advertising");
        }
    }

    public void androidStopAdvertising() {
        if (Build.VERSION.SDK_INT >= 21 && this.mBluetoothAdvertiser != null && this.advertisingCallback != null) {
            if (this.mBluetoothGattServer != null) {
                this.mBluetoothGattServer.clearServices();
                this.mBluetoothGattServer.close();
                this.mBluetoothGattServer = null;
            }
            if (this.mBluetoothAdvertiser != null) {
                this.mBluetoothAdvertiser.stopAdvertising(this.advertisingCallback);
                this.mBluetoothAdvertiser = null;
            }
            UnityBluetoothLE.UnitySend("StoppedAdvertising");
        } else {
            UnityBluetoothLE.UnitySend("Error~Failed to stop advertising");
        }
    }

    public void androidUpdateCharacteristicValue(String uuid, byte[] data, int length) {
        BluetoothGattCharacteristic gattCharacteristic = this.findCharacteristic(uuid = uuid.toLowerCase());
        if (gattCharacteristic != null) {
            gattCharacteristic.setValue(data);
            if (this.notifyDeviceMap != null && this.notifyDeviceMap.containsKey(UUID.fromString(uuid))) {
                ArrayList<BluetoothDevice> notifyDeviceList = this.notifyDeviceMap.get(UUID.fromString(uuid));
                for (int i = 0; i < notifyDeviceList.size(); ++i) {
                    this.mBluetoothGattServer.notifyCharacteristicChanged(notifyDeviceList.get(i), gattCharacteristic, false);
                }
            } else {
                UnityBluetoothLE.UnitySend("Error~Characteristic not found when updating value (2)");
            }
        } else {
            UnityBluetoothLE.UnitySend("Error~Characteristic not found when updating value (1)");
        }
    }

    static {
        CHARACTERISTIC_UPDATE_NOTIFICATION_DESCRIPTOR_UUID = UUID.fromString("00002902-0000-1000-8000-00805f9b34fb");
    }

    private class ServiceCharacteristicMap {
        public String UUID = "";
        public BluetoothGattService Service = null;
        public Map<String, BluetoothGattCharacteristic> characteristicMap = null;

        private ServiceCharacteristicMap() {
        }
    }

    public class UnityGattServices
    extends BluetoothGattServerCallback {
        public void setupServices(BluetoothGattServer gattServer, ArrayList<ServiceCharacteristicMap> serviceList) {
            if (gattServer != null && serviceList != null) {
                gattServer.clearServices();
                for (int i = 0; i < serviceList.size(); ++i) {
                    gattServer.addService(serviceList.get((int)i).Service);
                }
            }
        }

        public void onServiceAdded(int status, BluetoothGattService service) {
            if (status == 0) {
                Log.d((String)UnityBluetoothLE.TAG, (String)("onServiceAdded status=GATT_SUCCESS service=" + service.getUuid().toString()));
            } else {
                Log.d((String)UnityBluetoothLE.TAG, (String)"onServiceAdded status!=GATT_SUCCESS");
            }
        }

        public void onConnectionStateChange(BluetoothDevice device, int status, int newState) {
            Log.d((String)UnityBluetoothLE.TAG, (String)("onConnectionStateChange status=" + status + "->" + newState));
        }

        public void onCharacteristicReadRequest(BluetoothDevice device, int requestId, int offset, BluetoothGattCharacteristic characteristic) {
            Log.d((String)UnityBluetoothLE.TAG, (String)("onCharacteristicReadRequest requestId=" + requestId + " offset=" + offset));
            String uuid = characteristic.getUuid().toString();
            BluetoothGattCharacteristic myCharacteristic = UnityBluetoothLE.this.findCharacteristic(uuid);
            if (myCharacteristic != null) {
                characteristic.setValue(myCharacteristic.getValue());
            }
            UnityBluetoothLE.this.mBluetoothGattServer.sendResponse(device, requestId, 0, offset, characteristic.getValue());
        }

        public void onCharacteristicWriteRequest(BluetoothDevice device, int requestId, BluetoothGattCharacteristic characteristic, boolean preparedWrite, boolean responseNeeded, int offset, byte[] value) {
            Log.d((String)UnityBluetoothLE.TAG, (String)("onCharacteristicWriteRequest requestId=" + requestId + " preparedWrite=" + Boolean.toString(preparedWrite) + " responseNeeded=" + Boolean.toString(responseNeeded) + " offset=" + offset));
            String uuid = characteristic.getUuid().toString();
            BluetoothGattCharacteristic myCharacteristic = UnityBluetoothLE.this.findCharacteristic(uuid);
            if (myCharacteristic != null) {
                myCharacteristic.setValue(value);
                String dataString = Base64.encodeToString((byte[])Arrays.copyOfRange(value, 0, value.length), (int)0);
                UnityBluetoothLE.UnitySend("PeripheralReceivedWriteData~" + uuid + "~" + dataString);
            }
            UnityBluetoothLE.this.mBluetoothGattServer.sendResponse(device, requestId, 0, offset, null);
        }

        public void onDescriptorReadRequest(BluetoothDevice device, int requestId, int offset, BluetoothGattDescriptor descriptor) {
            super.onDescriptorReadRequest(device, requestId, offset, descriptor);
            UnityBluetoothLE.this.mBluetoothGattServer.sendResponse(device, requestId, 0, offset, null);
        }

        private void removeDeviceFromNotifyList(ArrayList<BluetoothDevice> notifyDeviceList, BluetoothDevice device) {
            for (int i = 0; i < notifyDeviceList.size(); ++i) {
                if (!notifyDeviceList.get(i).getAddress().equals(device.getAddress())) continue;
                notifyDeviceList.remove(i);
                break;
            }
        }

        public void onDescriptorWriteRequest(BluetoothDevice device, int requestId, BluetoothGattDescriptor descriptor, boolean preparedWrite, boolean responseNeeded, int offset, byte[] value) {
            super.onDescriptorWriteRequest(device, requestId, descriptor, preparedWrite, responseNeeded, offset, value);
            if (descriptor.getUuid().equals(UUID.fromString(UnityBluetoothLE.this.notificationDescriptionUUID))) {
                UUID uuid = descriptor.getCharacteristic().getUuid();
                if (UnityBluetoothLE.this.notifyDeviceMap == null) {
                    UnityBluetoothLE.this.notifyDeviceMap = new HashMap();
                }
                ArrayList notifyDeviceList = null;
                if (!UnityBluetoothLE.this.notifyDeviceMap.containsKey(uuid)) {
                    UnityBluetoothLE.this.notifyDeviceMap.put(uuid, new ArrayList());
                }
                notifyDeviceList = (ArrayList)UnityBluetoothLE.this.notifyDeviceMap.get(uuid);
                if (Arrays.equals(value, BluetoothGattDescriptor.ENABLE_NOTIFICATION_VALUE)) {
                    this.removeDeviceFromNotifyList(notifyDeviceList, device);
                    notifyDeviceList.add(device);
                } else if (Arrays.equals(value, BluetoothGattDescriptor.DISABLE_NOTIFICATION_VALUE)) {
                    this.removeDeviceFromNotifyList(notifyDeviceList, device);
                }
            }
            UnityBluetoothLE.this.mBluetoothGattServer.sendResponse(device, requestId, 0, offset, value);
        }
    }

    public class AdRecordList {
        List<AdRecord> Records = new ArrayList<AdRecord>();

        public List<AdRecord> parseScanRecord(byte[] scanRecord) {
            byte type;
            byte length;
            int index = 0;
            while (index < scanRecord.length && (length = scanRecord[index++]) != 0 && (type = scanRecord[index]) != 0) {
                byte[] data = Arrays.copyOfRange(scanRecord, index + 1, index + length);
                this.Records.add(new AdRecord(length, type, data));
                index += length;
            }
            return this.Records;
        }

        public AdRecord getRecord(int type) {
            for (AdRecord record : this.Records) {
                if (record.Type != type) continue;
                return record;
            }
            return null;
        }
    }

    public class AdRecord {
        public int Length;
        public int Type;
        public byte[] Data;

        public AdRecord(int length, int type, byte[] data) {
            this.Length = length;
            this.Type = type;
            this.Data = data;
        }

        public String decodeRecord() {
            String decodedRecord = "";
            try {
                decodedRecord = new String(this.Data, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            return decodedRecord;
        }
    }
}

